function [x,noisestd]=add_noise(SNR,x,mode)


 
M = size(x,1);
N = size(x,2);
K = size(x,3);

switch mode
    case 'g' %Gaussian
        randn('state',round(1000*sum(clock)));
        noisestd = std(x,[],2)*10^(-SNR/20);
        sigma    = repmat(noisestd,[1,N,K]);
        x        = x + randn(M, N, K).*sigma;
        
    case 'p' %Poisson
        x = x(:); 
        Tau = []; 
        Mean = mean(x);
        Std = std(x);
        Tau = (Mean/Std^2)*10^(SNR/10);
        x = poisson(x.*Tau);
        x = reshape(x,M,N,K); 
end
