
function [m,gam,alpha_minus,alpha_plus]=CoefMajorLog(kappa,theta,delta,alpha_j)
% ========================================================================
%Compute the parameters of the log-quadratic majorizing approximation of 
%b(alpha) =  -sum_i(kappa_i log(theta_i + alpha delta_i)) at alpha_j


%Function b presents vertical asymptotes at alpha_minus and alpha_plus
alpha_minus = max(-theta((delta>0)&(kappa~=0))./delta((delta>0)&(kappa~=0))) ;
alpha_plus = min(-theta((delta<0)&(kappa~=0))./delta((delta<0)&(kappa~=0))) ;

if isempty(alpha_minus)
    alpha_minus=-Inf;

end
if isempty(alpha_plus)
    alpha_plus=Inf;

end

%second derivative of b
ddb  =   @(alpha,i) sum(kappa(i).*(delta(i).^2)./(theta(i) + alpha.*delta(i)).^2);

I1 = (delta>0) ;
I2 = (delta<0) ;


%Majorant function parameters for alpha < alpha_j
m1 = ddb(alpha_j,I2);
gam1 = ddb(alpha_j,I1)*(alpha_minus-alpha_j);

%Majorant function parameters for alpha > alpha_j
m2 = ddb(alpha_j,I1);
gam2 = ddb(alpha_j,I2)*(alpha_plus-alpha_j);

m = [m1;m2];
gam = [gam1;gam2];
