function [A,a,a0,C,c,x0,xstar] = QuadPbMore(n,ncond,ndeg,nact,nact0,seed)

% ========================================================================
% Generate a random quadratic programming problem on the form
%
% min_x 1/2 x^T A x + a^T x + a0 s.t.  C x + c >= 0 
%
% according to the strategy defined in :
%
% Mor, J. J. et Toraldo, G. : "Algorithms for bound constrained quadratic programming 
% problems." Numerische Mathematik, 55:377400, 1989.
%
%----------------------------------------------------------------------
%Input:     n: size of x
%           ncond: positive parameter related to the conditioning of matrix A
%           ndeg: positive parameter related to the amount of degeneracy of the
%           constraints
%           nact: positive parameter related to the number of active constraints at
%           the solution
%           nact0: positive parameter related to the number of active constraints at
%           the initialization
%           seed: controls the seed of random numbers
%
%Output:    A,a,a0: parameters of the quadratic function to minimize
%           C,c: parameters of the linear constraints
%           x0: randomly generated vector such that C x + c >0
%           xstar: solution of the QP problem
%----------------------------------------------------------------------

rand('state', seed);

y = -1 + 2.* rand(n,1);

Y = eye(n)-(2/(y'*y))*(y*y');

N = 1:n;

d = exp((N-1)./(n-1).*ncond);
D = diag(d);

A = Y*D*Y;

Up = ones(n,1);
Lo = -ones(n,1);
 
xstar = Lo + (Up-Lo).* rand(n,1);

mu = rand(n,1);
absr = 10.^(-mu.*ndeg);

 
l = Lo;
u = Up;

r = zeros(n,1);

random = rand(n,1);
bern = -ones(n,1);
bern(mu<=nact/n) = (random(mu<=nact/n)  >=0.5);


ind1 = (mu<=nact/n & bern==1);
ind2 = (mu<=nact/n & bern==0);
 
l(ind1) = xstar(ind1);
r(ind1) = absr(ind1);

u(ind2) = xstar(ind2);
r(ind2) = -absr(ind2);

b = A*xstar-r;

a = -b;
a0 = 0;

C  = [-eye(n);eye(n)];   
c  = [u;-l];

x0 = (u+l)./2;
mu = rand(n,1);
random = rand(n,1);
bern = -ones(n,1);
bern(mu<=nact0/n) = (random(mu<=nact0/n)  >=0.5);

ind10 = (mu<=nact0/n & bern==1);
x0(ind10) = l(ind10) + eps;
ind20 = (mu<=nact0/n & bern==0);
x0(ind20) = u(ind20)-eps;

 

