%-------------------------------------------------------%
% Restoration program in the presence of Gaussian noise %
%                                                       %
%-------------------------------------------------------%



clc
close all
clear all
addpath Images
addpath Include

name = 'word';              %Name of the image
disp(['Load initial image ',name,'.txt']);

I = importdata(strcat(name,'.txt')); 
[Nx,Ny] = size(I);

disp('Create noisy image');
% Degradation parameters
sigma = 10;%standard deviation of Gaussian noise
Inoisy = I + randn(Nx, Ny) * sigma;
y = Inoisy(:);
SNRinit = 10*log10(sum(I(:).^2)/sum((I(:)-y).^2));

%Degradation operator and its adjoint
H = @(x) x;
H_adj = @(x) x;

% Majorize-Minimize Memory Gradient Algorithm parameters
NbIt = 10000;                       %Max iterations number
lambda = 500; delta = 10; phi = 1;  %Regularization parameter
xmin = 0; xmax = 255;               %Bounds of the constrained domain
tau = 0;                            %Elastic net parameter (0 for denoising)
eta = 0.5;                          %Weight of the quadratic distance function
x0 = zeros(Nx*Ny,1);                %Initialization

disp('Start iterative reconstruction');

[x,Crit,NGrad] = MajorizeMinimizeMemoryGradient(y,H,H_adj,eta,tau,lambda,delta,xmin,xmax,phi,x0,Nx,Ny,NbIt);

Irec = reshape(x,Nx,Ny);
SNRend = 10*log10(sum(I(:).^2)/sum((I(:)-Irec(:)).^2));

disp(['Initial SNR = ',num2str(SNRinit)]);
disp(['Final SNR = ',num2str(SNRend)]);

figure 
semilogy(Crit)
xlabel('Iterations')
ylabel('F(x)-F*')
figure 
semilogy(NGrad)
xlabel('Iterations')
ylabel('||dF(x)||')
figure
imagesc(I)
title('Original image')
colormap gray
set(gca,'xtick',[ ])
set(gca,'ytick',[ ])
figure
imagesc(Inoisy)
title(['Noisy image, SNR = ',num2str(SNRinit),' dB'])
colormap gray
set(gca,'xtick',[ ])
set(gca,'ytick',[ ])
figure 
imagesc(Irec);
colormap gray
title(['Restored image, SNR = ',num2str(SNRend),' dB'])
set(gca,'xtick',[ ])
set(gca,'ytick',[ ])
