function [Bx,v1,v2] = prox_tv_ind_metric(y, B, lambda, W, Wadj,  v1,v2, x, xmin, xmax,Nx,Ny)

CondCrit = 1e-5;
CondNorm = 1e-5;
NbrIt = 1000;
normW = 8;
B12 = sqrt(B) ;
B12inv = B12.^(-1) ;
    
z = B12.*y ;
rho = 1/ ( normW*max(1./B)) ;
epsilon = min(1,rho)- 1e-8 ;
gamma = 2*rho - epsilon ;
w=1/2 ;
lambdabar = lambda/w ;
Wx = W(x); 
    
    Crit(1) = lambda *norm_l12(Wx) + (1/2) * (x-y)' * ( B.*(x-y) ) ;
    Bx=B12inv.*x ;
     
    for k = 1:NbrIt
        
        Bxold = Bx ;
        x = z - (w * B12inv .* Wadj(v1) + (1-w)* B12inv .* v2) ; 
        Bx = B12inv.*x ;
        WBx = W(Bx) ;
        u1 = v1 + gamma * WBx ;
        u2 = v2 + gamma * Bx ;
        p1 = u1 - gamma * prox_tv(1,gamma^(-1)*u1, gamma^(-1).*lambdabar,Nx,Ny) ;
        p2 = u2 - gamma * proxind(gamma^(-1)*u2,xmin,xmax) ;
        v1 = p1 ;  
        v2 = p2 ;  
        
        Crit(k+1) = lambda * norm_l12(WBx) + (1/2) * (Bx-y)'*(B.*(Bx-y)) ;
        condnorm = norm(Bxold-Bx)/norm(y); 
        condcrit = abs(Crit(k+1)-Crit(k))/abs(Crit(1)) ;

        if( (condcrit < CondCrit) && ( condnorm < CondNorm ) ) 
             
            break
        end
    end

    
end

function tv = norm_l12(Wx)
N = length(Wx);
Wux = Wx(1:N/2);
Wvx = Wx(N/2+1:N);
tv = sum(sqrt(Wux.^2 + Wvx.^2));


end
