%-------------------------------------------------------------------%
% Deconvolution program in the presence of Gaussian dependant noise %
%                                                                   %
%-------------------------------------------------------------------%


clc
close all
clear all
addpath Images
addpath Algorithms
addpath Tools

name = 'jetplane';                   %Name of the image
disp(['Load initial image ',name,'.txt']);
I = importdata(strcat(name,'.txt')); 
[Nx,Ny] = size(I);

disp('Create blurry and noisy image');
% Degradation parameters
h = fspecial('gaussian',7,1);       %Convolution kernel (h = 1 if denoising)
a = 1; b = 1;                       %Parameters of Gaussian dependant noise
Iblur = conv2(I,h,'same');
Iblurnoisy = Iblur + randn(Nx,Ny).*sqrt( a.*Iblur +  b);
y = Iblurnoisy(:);
SNRinit = 10*log10(sum(I(:).^2)/sum((I(:)-y).^2));

%Degradation operator and its adjoint
H = @(x) reshape(conv2(reshape(x,Nx,Ny),h,'same'),Nx*Ny,1);
H_adj = @(y) reshape(conv2(reshape(y,Nx,Ny),fliplr(flipud(h)),'same'),Nx*Ny,1);

%Warning : the proposed method requires H_mn >= 0 for all (m,n) !

%%
% Variable Metric Forward-Backward Algorithm parameters
NbIt = 5000;                        %Max iterations number
TimeMax = 120;                      %Max computation time (in s)
nu = 0.03;                          %Regularization parameter
xmin = 0; xmax = max(I(:));         %Bounds of the constrained domain
x0 = zeros(Nx*Ny,1);                %Initialization

gamma = 1.9;                        %Stepsize parameter
lambda = 1;                         %Relaxation parameter

disp('Start iterative reconstruction');

[xvmfb,Critvmfb,SNRvmfb,NGradvmfb,Timevmfb] = VariableMetricForwardBackward(y,H,H_adj,a,b,nu,gamma,lambda,x0,I,Nx,Ny,xmin,xmax,NbIt,TimeMax); 
[xfb,Critfb,SNRfb,NGradfb,Timefb] = ForwardBackward(y,H,H_adj,a,b,nu,gamma,lambda,x0,I,Nx,Ny,xmin,xmax,NbIt,TimeMax); 
[xfista,Critfista,SNRfista,NGradfista,Timefista] = FISTA(y,H,H_adj,a,b,nu,x0,I,Nx,Ny,xmin,xmax,NbIt,TimeMax); 

x = xvmfb;
Irec = reshape(x,Nx,Ny);
SNRend = 10*log10(sum(I(:).^2)/sum((I(:)-x).^2));
 
Gstar = min([Critvmfb(end) Critfb(end) Critfista(end)]);
close all hidden


figure 
semilogy(cumsum(Timevmfb),Critvmfb-Gstar,'linewidth',2)
hold on
semilogy(cumsum(Timefb),Critfb-Gstar,'--r','linewidth',2)
hold on
semilogy(cumsum(Timefista),Critfista-Gstar,':k','linewidth',2) 
xlabel('Time (s)')
ylabel('F(x_k)-F(x*)')
legend('VMFB','FB','FISTA')
figure 
plot(cumsum(Timevmfb),SNRvmfb,'linewidth',2)
hold on
plot(cumsum(Timefb),SNRfb,'--r','linewidth',2)
hold on
plot(cumsum(Timefista),SNRfista,':k','linewidth',2)
xlabel('Time (s)')
ylabel('SNR(x_k)')
legend('VMFB','FB','FISTA')
figure
imagesc(I)
title('Original image')
colormap gray
axis image off
figure
imagesc(Iblurnoisy)
title(['Noisy blurred image, SNR = ',num2str(SNRinit),' dB'])
colormap gray
axis image off
figure 
imagesc(Irec);
colormap gray
title(['Restored image, SNR = ',num2str(SNRend),' dB'])
axis image off

 