function WLBrowser
% WLBrowser -- WaveLab Browser
%  Usage
%    WLBrowser
%  Inputs
%    none
%  Outputs
%    none
%
%  Description
%    The WaveLab Browser implements a point-and-click
%    interface to WaveLab functions.
%
disp('***********************************************')
disp('*               WaveLab Browser               *')
disp('***********************************************')
st = '----------------------------------------------------';
disp(' ' )
disp('This WaveLab MATLAB program lets you try out standard')
disp('Wavelet Analysis techniques on standard or synthetic data sets.')
disp(' ')
disp('Here is a summary of how to use the menus:')
disp(' ')

disp(st)
disp('Data:    Load data from WaveLab''s standard data sets:')
disp('         (Caruso, Laser, Sunspots, Seismic, ESCA, HochNMR, RaphaelNMR)')
disp(' ')

disp(st)
disp('Signals:  Use a built-in artificial signal')
disp('         (Bumps, Blocks, LinChirp, TwoChirp, ...)')
disp(' ')


disp('Xforms:')
disp('         Sqrt      - square root transformation')
disp('         Log       - log transformation')
disp('         Anscombe  - square root transformation')
disp('         Wahba     - log transformation of periodogram')
disp('         Pgram     - periodogram')
disp('         Add Noise - apply the currently defined noise to the data & plot')
disp('         Normalize - apply the WaveLab routine ''NormNoise'' to the data and plot it.')
disp(st)

disp('Actions:')
disp('         Plot_WT  - Plot Wavelet Transforms ')
disp('         Plot_MRA - Plot Multi-Resolution Analysis ')
disp('         Plot_DCT - Plot Discrete Cosine Transforms ')
disp('         WPTour   - Wavelet Packet & Best Basis Analysis ')
disp('         CPTour   - Cosine Packets & Best Basis Analysis ')
disp('         DeNoise  - carry out the denoising of the data; display results')
disp(st)

disp('Params:')
disp('         Wavelet       - Select the wavelet for the wavelet transform')
disp('         Bell          - Select the bell to be used in  cosine packets')
disp('         Nonlinearity  - type of thresholding to use in denoising')
disp('         Threshold Selector - method of selecting the threshold')
disp('         Noise Type    - type of noise to use when adding noise')
disp('         Noise Level   - amplitude of noise when adding noise')
disp('         Signal Length - signal length when fabricating artificial signal')
disp(st)

disp('KEEP THIS TEXT WINDOW HANDY AND YOU WILL SEE COMMENTS')
disp('AND THE MATLAB COMMANDS DISPLAYED AS THEY ARE EXECUTING,')
disp('FROM TIME TIME TO TIME YOU WILL HAVE TO ENTER DATA HERE.')
disp(st)

clear;close;close;close
do_global
back_color = [ 0 , 0, 0 ];
echo off

num_menus = 5;
  menu_names = [ ...
    'Data___'; ...
    'Signals'; ...
    'Xforms_'; ...
    'Actions'; ...
    'Params_'; ...
               ];

% To add menu items, increase the appropriate number in the array
% below, and add the corresponding 'entries' and 'call backs':
  num_menu_items = [  8 15 6 10 0];

% -- Data for Data menu # 1 --- %


Data____entries = [ ...
          'Caruso      ' ; ...
          'Laser       ' ; ...
          'Sunspots    ' ; ...
          'Seismic     ' ; ...
          'ESCA        ' ; ...
          'HochNMR     ' ; ...
          'RaphaelNMR  ' ; ... 
          'User Defined' ; ...
               ];

% dummy = [ 'def_data( 1 );' ; ...
Data____callbacks = [ ...
  'def_data( 0 );' ; ...
  'def_data( 1 );' ; ...
  'def_data( 2 );' ; ...
  'def_data( 3 );' ; ...
  'def_data( 4 );' ; ...
  'def_data( 5 );' ; ...
  'def_data( 6 );' ; ...
  'def_data( 7 );' ; ...
  ];

% -- Data for Signals menu #2 --- %

Signals_entries = [ ...
          'HeaviSine        ' ; ...
          'Bumps            ' ; ...
          'Blocks           ' ; ...
          'Doppler          ' ; ...
          'Ramp             ' ; ...
          'Cusp             ' ; ...
          'Sing             ' ; ...
          'HiSine           ' ; ...
          'LoSine           ' ; ...
          'LinChirp         ' ; ...
          'TwoChirp         ' ; ...
          'QuadChirp        ' ; ...
          'MishMash         ' ; ...
          'WernerSorrows    ' ; ...
          'Leopold          ' ; ...
               ];

Signals_callbacks = [ ...
  'def_signal( 1);' ; ...
  'def_signal( 2);' ; ...
  'def_signal( 3);' ; ...
  'def_signal( 4);' ; ...
  'def_signal( 5);' ; ...
  'def_signal( 6);' ; ...
  'def_signal( 7);' ; ...
  'def_signal( 8);' ; ...
  'def_signal( 9);' ; ...
  'def_signal(10);' ; ...
  'def_signal(11);' ; ...
  'def_signal(12);' ; ...
  'def_signal(13);' ; ...
  'def_signal(14);' ; ...
  'def_signal(15);' ; ...
  ];

% -- Data for Xforms menu #3 --- %

Xforms__entries = [ ...
         'Sqrt     ' ; ...
         'Log      ' ; ...
         'Anscombe ' ; ...
         'Wahba    ' ; ...
         'Add Noise' ; ...
         'Normalize' ; ...
               ];

Xforms__callbacks = [ ...
  'do_transform(''sqrt '')'; ...
  'do_transform(''log  '')'; ...
  'do_transform(''Frank'')'; ...
  'do_transform(''Grace'')'; ...
  'do_transform(''noise'')'; ...
  'do_transform(''scale'')'; ...
  ];

%% -- Data for Actions menu #4 --- %

Actions_entries = [ ...
         'Plot_WT    ' ; ...
         'Plot_MRA   ' ; ...
         'Plot_DCT   '; ...
         'WPTour     '; ...
         'CPTour     '; ...
         'WT Compress'; ...
         'WT DeNoise ' ; ...
         'WP Compress'; ...
         'CP Compress'; ...
         'Quit       ' ; ...
        ];

Actions_callbacks = [ ...
    'do_action(1) '; ...
    'do_action(2) '; ...
    'do_action(3) '; ...
    'do_action(4) '; ...
    'do_action(5) '; ...
    'do_action(6) '; ...
    'do_action(7) '; ...
    'do_action(8) '; ...
    'do_action(9) '; ...
    'do_action(10)';
  ];

% -- Data for Params menu #5 --- %

Params__entries = [ ...
          'Wavelets     ' ; ...
          'Bell         ' ; ...
          'Nonlinearity ' ; ...
          'Threshold    ' ; ...
          'Noise Type   ' ; ...
          'Noise Level  ' ; ...
          'Signal Length'; ...
        ];

Params__callbacks = [ ...
  'define_ ( 1 );'; ...
  'define_ ( 2 );'; ...
  'define_ ( 3 );'; ...
  'define_ ( 4 );'; ...
  'define_(5);   ';
  'define_(6);   ';
  'define_(7);   ';
  ];





disp('%*******************************')
disp('% ===   Set Up The Menus   === *')
disp('%*******************************')

for ii = 1:num_menus

  menu_name = menu_names( ii, : );
  menu_tag = menu_name;
  menu_tags( ii, : ) = [ '*' menu_tag ];

  while menu_tag(length(menu_tag)) == '_'
    menu_tag(length(menu_tag)) = [];
  end
  menu_id = uimenu('Label', [ '*' menu_tag '    ' ] );
  menu_ids( ii ) = menu_id;
  if num_menu_items(ii) > 0,
      for kk = 1:num_menu_items( ii )
    
        st = [ 'menu_label = ' menu_name '_entries( kk, : );' ];
        eval( st );
    
        st = [ 'callback = ' menu_name '_callbacks( kk, : );' ];
        eval( st );
    
        uimenu( menu_id, ...
        'Label', menu_label, ...
        'CallBack', callback ...
              );
      end
  end
end

%
% Last menu is hierarchical
%

    h_par = menu_ids(5);
    h_wav = uimenu(h_par,'Label','Wavelet');
    h_bel = uimenu(h_par,'Label','Bell','Separator','on');
    h_non = uimenu(h_par,'Label','Nonlinearity','Separator','on');
    h_thr = uimenu(h_par,'Label','Threshold Selector','Separator','on');
    h_noi = uimenu(h_par,'Label','Noise Type','Separator','on');
    h_nlv = uimenu(h_par,'Label','Noise Level','Separator','on');
    h_ent = uimenu(h_par,'Label','Entropy Type','Separator','on');
    h_sig = uimenu(h_par,'Label','Signal Length','Separator','on');
%
%   Wavelet submenu
%
    global h_wavemenu
    h_wavemenu = zeros(4,1);
    h_wavemenu(1) = uimenu( h_wav, 'Label', 'Haar', ...
                   'Checked', 'on', 'CallBack', 'def_filter(1);');
    h_wavemenu(2) = uimenu( h_wav, 'Label', 'Daubechies', ...
                   'Checked', 'off', 'CallBack', 'def_filter(2);');
    h_wavemenu(3) = uimenu( h_wav, 'Label', 'Average-Interpolating', ...
                   'Checked', 'off', 'CallBack', 'def_filter(3);');
    h_wavemenu(4) = uimenu( h_wav, 'Label', 'Coiflet', ...
                   'Checked', 'off', 'CallBack', 'def_filter(4);');
    h_wavemenu(5) = uimenu( h_wav, 'Label', 'Symmlet', ...
                   'Checked', 'off', 'CallBack', 'def_filter(5);');
%
%   Bell submenu
%
    global h_bellmenu
    h_bellmenu = zeros(2,1);
    h_bellmenu(1) = uimenu( h_bel, 'Label', 'Sine', ...
                   'Checked', 'on', 'CallBack', 'def_bell(1);');
    h_bellmenu(2) = uimenu( h_bel, 'Label', 'Trivial', ...
                   'Checked', 'off', 'CallBack', 'def_bell(2);');

%
%   Nonlinearity submenu
%
    global h_nonmenu
    h_nonmenu = zeros(2,1);
    h_nonmenu(1) = uimenu( h_non, 'Label', 'Soft Threshold', ...
                   'Checked', 'on', 'CallBack', 'def_nonlin(1);');
    h_nonmenu(2) = uimenu( h_non, 'Label', 'Hard Threshold', ...
                   'Checked', 'off', 'CallBack', 'def_nonlin(2);');

%
%   Threshold submenu
%
    global h_thrmenu
    h_thrmenu = zeros(5,1);
    h_thrmenu(1) = uimenu( h_thr, 'Label', 'Visu', ...
                   'Checked', 'on' , 'CallBack', 'def_shrinker(1);');
    h_thrmenu(2) = uimenu( h_thr, 'Label', 'SURE', ...
                   'Checked', 'off', 'CallBack', 'def_shrinker(2);');
    h_thrmenu(3) = uimenu( h_thr, 'Label', 'Hybrid', ...
                   'Checked', 'off', 'CallBack', 'def_shrinker(3);');
    h_thrmenu(4) = uimenu( h_thr, 'Label', 'MAD', ...
                   'Checked', 'off', 'CallBack', 'def_shrinker(4);');
    h_thrmenu(5) = uimenu( h_thr, 'Label', 'MinMax', ...
                   'Checked', 'off', 'CallBack', 'def_shrinker(5);');
%
%   Noise Type Submenu
%

    global h_noimenu
    h_noimenu = zeros(3,1);
    h_noimenu(1) = uimenu( h_noi, 'Label', 'Gaussian', ...
                   'Checked', 'on' , 'CallBack', 'def_noise(1);');
    h_noimenu(2) = uimenu( h_noi, 'Label', 'Uniform', ...
                   'Checked', 'off', 'CallBack', 'def_noise(2);');
    h_noimenu(3) = uimenu( h_noi, 'Label', 'Poisson', ...
                   'Checked', 'off', 'CallBack', 'def_noise(3);');
%
%   Noise Level Submenu
%
    global h_nlvmenu
    h_nlvmenu = zeros(3,1);
    h_nlvmenu(1) = uimenu( h_nlv, 'Label', 'Zero Noise', ...
                   'Checked', 'off', 'CallBack', 'def_nlevel(1);');
    h_nlvmenu(2) = uimenu( h_nlv, 'Label', 'Unit Noise', ...
                   'Checked', 'on' , 'CallBack', 'def_nlevel(2);');
    h_nlvmenu(3) = uimenu( h_nlv, 'Label', 'Custom Noise', ...
                   'Checked', 'off', 'CallBack', 'def_nlevel(3);');
%
%   Entropy type Submenu
%
    global h_entmenu
    h_entmenu = zeros(5,1);
    h_entmenu(1) = uimenu( h_ent, 'Label', 'Entropy', ...
                   'Checked', 'on' , 'CallBack', 'def_entropy(1);');
    h_entmenu(2) = uimenu( h_ent, 'Label', 'l^1', ...
                   'Checked', 'off', 'CallBack', 'def_entropy(2);');
    h_entmenu(3) = uimenu( h_ent, 'Label', 'N(eps)', ...
                   'Checked', 'off', 'CallBack', 'def_entropy(3);');
    h_entmenu(4) = uimenu( h_ent, 'Label', 'Risk', ...
                   'Checked', 'off', 'CallBack', 'def_entropy(4);');
    h_entmenu(5) = uimenu( h_ent, 'Label', 'SURE', ...
                   'Checked', 'off', 'CallBack', 'def_entropy(5);');
%
%   Signal Length Submenu
%
    global h_sigmenu
    h_sigmenu = zeros(3,1);
    h_sigmenu(1) = uimenu( h_sig, 'Label', '512', ...
                   'Checked', 'off', 'CallBack', 'def_siglen( 512);');
    h_sigmenu(2) = uimenu( h_sig, 'Label', '1024', ...
                   'Checked', 'off', 'CallBack', 'def_siglen(1024);');
    h_sigmenu(3) = uimenu( h_sig, 'Label', '2048', ...
                   'Checked', 'on',  'CallBack', 'def_siglen(2048);');
    h_sigmenu(4) = uimenu( h_sig, 'Label', '4096', ...
                   'Checked', 'off', 'CallBack', 'def_siglen(4096);');
    h_sigmenu(5) = uimenu( h_sig, 'Label', '8192', ...
                   'Checked', 'off', 'CallBack', 'def_siglen(8192);');

%
%   Initialize Figures
%


        screen = get(0,'ScreenSize');
        width = screen(3)
        height = screen(4)
    
        wid2 = floor(width/2);
        hgt2 = floor(height/2);
    
        PlotFig = 1;
        rect1 = [0 hgt2 wid2 hgt2];
        set(PlotFig,'Position',rect1);
 
%   
        fig_hand1 = figure;

        set( fig_hand1, 'Color', back_color );
        set( fig_hand1, 'Name', 'Signal/Reconstruction' );
        rect2 = [wid2 hgt2 wid2 hgt2];
        set(fig_hand1,'Position',rect2);
    
        fig_hand2 = figure;
        set( fig_hand2, 'Color', back_color );
        set( fig_hand2, 'Name', 'Transform' );
        rect3 = [0 0 wid2 hgt2];
        set( fig_hand2 ,'Position',rect3);
    
        fig_hand3 = figure;
        set( fig_hand3, 'Color', back_color );
        set( fig_hand3, 'Name', 'Auxiliary' );
        rect4 = [wid2 0 wid2 hgt2];
        set( fig_hand3,'Position',rect4);
    
    figure( PlotFig );


%   set up default values 
%
    global nsig
    filter_type = 1;
    QMF_Filter = MakeONFilter('Haar',1);
    Coarse = 4;
    shrinkage_type = 1;
    noise_type = 1;
    ent_type   = 'Entropy';
    ent_par    = 0;
    
    namp = 1;
    nsig = 2048;
    n = 256;
    Empty_Data = 1;
    signal_name = 'Zero';
    
    panel = n/2;
    ylim  = [-1 1];
    x_use  = zeros(1,n);
%
%
%   set up signal window
%
figure(PlotFig);
axes('position',[0.05,0.25,0.9,.65]);
set( PlotFig, 'Name', 'Signal: Nil' );

set(PlotFig,'UserData',[ylim,panel,x_use]);
HC = uicontrol('style','slider','units','normal','pos',[.05,.05,.9,.05],...     
      'min',0,'max',1,'value',.5,...
     'call','do_button(''slider'');');
uicontrol('style','pushbutton','units','normal','string','*2  ',...
     'pos',[0.05,0.11,0.1, 0.05],...
     'call','do_button(''double'');');
uicontrol('style','pushbutton','units','normal','string','/2  ',...
     'pos',[0.15,0.11,0.1, 0.05],...
     'call','do_button(''half'');');
uicontrol('style','pushbutton','units','normal','string','Prev',...
     'pos',[0.25,0.11,0.1, 0.05],...
     'call','do_button(''prev'');');
uicontrol('style','pushbutton','units','normal','string','Next',...
     'pos',[0.35,0.11,0.1, 0.05],...
     'call','do_button(''next'');');
uicontrol('style','pushbutton','units','normal','string','Full',...
     'pos',[0.45,0.11,0.1, 0.05],...
     'call','do_button(''full'');'); 
uicontrol('style','pushbutton','units','normal','string','Play',...
     'pos',[0.65,0.11,0.1, 0.05],...
     'call','do_button(''play'');');
uicontrol('style','pushbutton','units','normal','string','Zoom',...
     'pos',[0.75,0.11,0.1, 0.05],...
     'call','do_button(''zoom'');');
update_plot(get(HC,'value'));
text(.4*n,.7,'Tile all 5 windows');
text(.4*n,.5,'Select *Data or *Signal to start');

% clean up

clear h_bel h_nlv h_noi h_par h_sig h_thr h_wav h_non
clear menu_id menu_label menu_names menu_name menu_tag
clear num_menu_items num_menus panel st ylim ii kk lo back_color
clear rect1 rect2 rect3 rect4 screen width height


%  Revision History
%             10/1/05     AM     the name of the variable QMF is changed to
%                                 QMF filter


    
 
 
%
%  Part of Wavelab Version 850
%  Built Tue Jan  3 13:20:39 EST 2006
%  This is Copyrighted Material
%  For Copying permissions see COPYING.m
%  Comments? e-mail wavelab@stat.stanford.edu 
