% Datasets:Contents v850 -- Datasets, Documentation, and Readers
%
%          Data Readers
%
%   BrowseImages        -   Browser for Image Datasets
%   ImageFig            -   Called by BrowseImages
%   ReadImage           -   Uniform Interface to Image Datasets
%   ReadSignal          -   Uniform Interface to Signal Datasets
%
%
%          Data Fabricators
%
%   MakeBrownian        -   Make Fractional Brownian Motions
%   MakeCantor          -   Recursively generates a Cantor distribution.
%   MakeFractal         -   Make fractal signals
%   MakeImage           -   Make artificial 2d signal (enhanced of Make2dSignal)
%   MakeProcess         -   Make locally stationary process
%   MakeSignal          -   Make artificial signal
%   Make2dSignal        -   Make artificial 2d signal
%   makediag            -   Make diagonal pattern (used by Make2dSignal)
%
%
%          1-d Signals
%
%   caruso.asc          -   old recording by Enrico Caruso
%   esca.asc            -   ESCA spectrum supplied by J.P. Bib\'erian
%   greasy.asc          -   recording of the word ``greasy'' from
%                             Mallat and Zhang
%   HochNMR.asc         -   NMR Spectrum supplied by Jeff Hoch
%   lady.asc            -   See in Books/WaveTour/WTCh06/wt06fig07.m,
%                             wt06fig08.m, wt07fig03.m, wt07fig07.m
%   laser.asc           -   Time Series competition Laser series
%   msignal.asc         -   Artificial signal in the article of Mallat & Zhong
%   RaphNMR.asc         -   NMR Spectrum supplied by Adrian Maudsley
%   seismic.asc         -   standard PROMAX test seismic signal
%   SonRemy.asc         -   Vocalises
%   sunspots.asc        -   sunspot numbers
%   transients.asc      -   artificial signal of Mallat and Zhang
%   tweet.asc           -   recording of a bird singing
%
%
%          2-d Images 
%
%   barb.raw            -   ???
%   barton.raw          -   painting of seashore compressed by
%                             Jan-Olov Stromberg
%   canaletto.raw       -   painting of Venice processed by
%                             P. Perona and J. Malik
%   coifman.raw         -   photo of R.R. Coifman
%   daubechies.raw      -   photo of Ingrid Daubechies
%   fingerprint.raw     -   someone's fingerprint
%   lenna.raw           -   Lenna
%   lincoln.raw         -   Honest Abe
%   mriscan.raw         -   someone's brain
%   peppers256.raw      -   See in Books/WaveTour/WTCh10/wt10fig05.m
%   phone.raw           -   someone's phone
%   
%
%          Utilities
%   makediag            -   Make a diagonal pattern
%   mat2raw             -   MAT2RAW(filename,x) writes matrix 'x' into file 'filename' in
%                           'raw' form.
%   raw2mat             -   mat = RAW2MAT(filename,lines,columns) loads a '.raw' file into
%                           matrix 'mat' of size 'lines' * 'columns'.
%
    
 
 
%
%  Part of Wavelab Version 850
%  Built Tue Jan  3 13:20:39 EST 2006
%  This is Copyrighted Material
%  For Copying permissions see COPYING.m
%  Comments? e-mail wavelab@stat.stanford.edu 
