% Interpolating:Contents v850 -- Interpolating Refinements and Wavelet Transforms
%
% This directory contains tools for Deslauriers-Dubuc (interpolating)
% refinement for average-interpolating refinement, and the associated
% Multi-Resolution analyses and associated Wavelet Transforms.
%
% Background Reading: D.L. Donoho, Interpolating Wavelet Transforms;
%     Smooth Wavelet Decompositions with Blocky Coefficient Kernels
%
%          Deslauriers-Dubuc Refinement & Associated Tools
%
% DDRefine          -   Deslauriers-Dubuc Refinement Scheme
% MakeDDFilter      -   Filters for Deslauriers-Dubuc Refinement
% MakeDDBdryFilter  -   Edge Filters for Deslauriers-Dubuc Refinement
%
% FWT_DD            -   Fast interpolating wavelet transform
% IWT_DD            -   Fast interpolating inverse wavelet transform
%
% PlotDDMultiRes  - Display 1-d DD MRA
%
% DDDyadDown        -   Interpolating DownSampling Operator
% DDDyadUp          -   Interpolating UpSampling Operator
%
%          Average-Interpolating Refinement & Associated Tools
%
% AIRefine          -   Average-Interpolating Refinement Scheme
% AIRefine2d        -   Average-Interpolating Refinement Scheme (2d)
% MakeAIFilter      -   Filters for Average-Interpolating Refinement
% MakeAIBdryFilter  -   Edge Filters for Average-Interpolating Refinement
%
% FWT_AI            -   Fast average-interpolating wavelet transform
% IWT_AI            -   Fast average-interpolating inverse wavelet
transform
%
% PlotAIMultiRes    -   Display 1-d AI MRA
%
% AIDyadDown        -   Average-Interpolating DownSampling Operator
% AIDyadUp          -   Average-Interpolating UpSampling Operator
%
%          Utilities
%
% HCoarsen2d        -   2-d Coarsening operator based on Haar Pyramid
% HRefine2d         -   2-d Refinement based on Haar Pyramid
%
    
    
 
 
%
%  Part of Wavelab Version 850
%  Built Tue Jan  3 13:20:40 EST 2006
%  This is Copyrighted Material
%  For Copying permissions see COPYING.m
%  Comments? e-mail wavelab@stat.stanford.edu 
