% Papers:Contents v850 -- Reproducing Figures from Published Articles
% 
% This directory contains several subdirectories; each one of these
% contains scripts that were used to produce figures in our published
% articles.  As new articles are written by members of our group, we will
% add new subdirectories. Each subdirectory contains a ``demo'' file
% which allows one to reproduce the figures in the corresponding article.
% 
% When a demo file is invoked, a menu bar will appear on the screen. 
% Clicking with the mouse on the menu item ``Show All Figures'' will
% produce, in sequence, each figure in the corresponding article.  As
% each figure appears in the Matlab figure window, the command window
% will contain narrative explaining what the figure window illustrates.
% 
% The directory name, corresponding paper name and corresponding demo name
% are listed herein:
% 
% Adapt           -   ``Adapting to Unknown Smoothness via Wavelet Shrinkage''
%                       (AdaptDemo)
% Asymp           -   ``Wavelet Shrinkage: Asymptopia?'' (AsympDemo)
% Blocky          -   ``Smooth Wavelet Decomposition with Blocky Coefficient
%                       Kernals'' (BlockyDemo)
% Correl          -   ``Wavelet Threshold Estimators for Data with
%                       Correlated Noise" (CorrelDemo)
% Ideal           -   ``Ideal Spatial Adaptation via Wavelet Shrinkage''
%                       (IdealDemo)
% MinEntSeg       -   ``On Minimum Entropy Segmentation'' (MESDemo)
% MIPT            -   ``Nonlinear Wavelet Transforms based on Median-
%                       Interpolation'' (MIPTDemo)
% RiskAnalysis    -   ``Exact Risk Analysis of Wavelet Regression'' (RiskDemo)
% ShortCourse     -   ``Nonlinear Wavelet Methods for Recovery of Signals,
%                       Densities, Spectra and Images from Incomplete and
%                       Noisy Data'' (SCDemo)
% Tour            -   ``Wavelet Shrinkage and W.V.D. -- A Ten-Minute Tour''
%                       (TourDemo)
% SpinCycle       -   ``Translation-Invariant De-Noising'' (SpinDemo)
% VillardDeLans   -   ``WaveLab and Reproducible Research'' (VdLDemo)
%
