function [data, test] = load_MNIST()

% load data for "training" and "validation"
data.samples = read_MNIST_features('60000_features');
data.labels  = read_MNIST_labels('60000_labels');

% load data for "testing"
test.samples = read_MNIST_features('10000_features');
test.labels  = read_MNIST_labels('10000_labels');

% normalize data
data.samples = normalization(data.samples, 'unitary');
test.samples = normalization(test.samples, 'unitary');

% avoid the zero in the labels
data.labels = data.labels + 1;
test.labels = test.labels + 1;