function data = read_MNIST_features(cFileName)

% open the file
fid = fopen(cFileName, 'r', 'ieee-be');

% read the header
magic_number = fread(fid, 1, 'int32');
N_items      = fread(fid, 1, 'int32');
Nr           = fread(fid, 1, 'int32');
Nc           = fread(fid, 1, 'int32');

% read the items
data = fread(fid, inf, 'uint8');
data = reshape(data, [Nr*Nc, N_items])';

% close the file
fclose(fid);