function [data, test] = load_RCV1(numClasses)

% get the files' path
trainfile = which('rcv1_train.multiclass');
testfile  = which('rcv1_test.multiclass');

% load "training" data
[labels, samples] = libsvmread(trainfile);
data.labels  = labels;
data.samples = full(samples);

% load "test" data
[labels, samples] = libsvmread(testfile);
test.labels  = labels;
test.samples = samples;

% select the classes to be discarded
totalClasses = length(unique(data.labels));
discarded = numClasses+1 : totalClasses;
data_idx = find( ismember(data.labels,discarded) );
test_idx = find( ismember(test.labels,discarded) );

% remove data
data.samples(data_idx,:) = [];
data.labels (data_idx)   = [];
test.samples(test_idx,:) = [];
test.labels (test_idx)   = [];