function [x, it, time, crit, conv] = exec_algo(name, x, f, h, opt, x_inf)

if nargin < 6 || isempty(x_inf)
    x_inf = 0;
end

if strcmpi(name, 'pd')    
    [x,it,time,crit,conv] = PD      (x, f, [], h, opt, x_inf);
elseif strcmpi(name, 'dr')
    [x,it,time,crit,conv] = DR      (x, f,     h, opt, x_inf);
elseif strcmpi(name, 'dr2')
    [x,it,time,crit,conv] = DR2     (x, f,     h, opt, x_inf);
elseif strcmpi(name, 'fista')
    [x,it,time,crit,conv] = FISTA   (x, f,     h, opt, x_inf);
elseif strcmpi(name, 'bcpd')    
    [x,it,time,crit,conv] = PD_block(x, f, [], h, opt, x_inf);
elseif strcmpi(name, 'bcdr')    
    [x,it,time,crit,conv] = DR_block(x, f,     h, opt, x_inf);
elseif strcmpi(name, 'bcdr2')    
    [x,it,time,crit,conv] =DR2_block(x, f,     h, opt, x_inf);
elseif strcmpi(name, 'sfb')    
    [x,it,time,crit,conv] = SFB     (x, f,     h, opt, x_inf);
elseif strcmpi(name, 'rda')    
    [x,it,time,crit,conv] = RDA     (x, f,     h, opt, x_inf);
elseif strcmpi(name, 'async')    
    [x,it,time,crit,conv] = ASYNC   (x, f,     h, opt, x_inf);
elseif strcmpi(name, 'PFWD')    
    [x,it,time,crit,conv] = PFWD    (x, f,     h, opt, x_inf);
elseif strcmpi(name, 'PFWD2')    
    [x,it,time,crit,conv] = PFWD2   (x, f,     h, opt, x_inf);
else
    error('Algorithm not supported');
end