function [w, it, time, crit] = DR(w, f, h, opt)

% default inputs
if nargin < 2 || isempty(f),   f.fun = @(x) 0; f.prox = @(x,gamma) x;                                                end
if nargin < 3 || isempty(h),   h.fun = @(y) 0; h.prox = @(y,gamma) y; h.dir_op = @(x) x; h.adj_op = @(y) y; h.Q = 1; end
if nargin < 4 || isempty(opt), opt.tol = 1e-4; opt.iter = 500;                                                       end

% select the step-sizes
gamma = 0.25;
mu    = 1.8;
rho   = 3.99;

% invert the matrix
Q = inv( eye(size(h.Q)) + gamma^2 / (1+gamma*rho) * h.Q );

% initialize the dual solution
t = w;
s = h.dir_op(w);

% execute the algorithm
time = zeros(1, opt.iter);
crit = zeros(1, opt.iter);
hdl = waitbar(0, 'Primal-Dual Douglas-Rachford');
for it = 1:opt.iter
    
    tic;
    
    w_old = w;
    
    % average step
    w = Q * ( t - gamma/(1+gamma*rho) * h.adj_op(s) );
    Fw = h.dir_op(w);
    v = (s + gamma * Fw) / (1+gamma*rho);
    
    % primal step
    t = t + mu * ( f.prox(2*w - t, gamma) - w );
    
    % dual step
    vs = (2*v - s) / (1-gamma*rho);
    s = s + mu * ( vs - v - gamma/(1-gamma*rho) * h.prox(vs/gamma*(1-gamma*rho), (1-gamma*rho)/gamma) ); 

    % time and criterion
    time(it) = toc;
    crit(it) = f.fun(w) + h.fun(Fw);
           
    % stopping rule
    if norm( w(:) - w_old(:) ) < opt.tol * norm( w_old(:) ) && it > 10
        break;
    end
    
%     if rem(it,50)
%         figure(10);
%         subplot(3,1,1); plot(u,   'linewidth', 2);
%         subplot(3,1,2); plot(v,   'linewidth', 2);
%         subplot(3,1,3); plot(v-y, 'linewidth', 2);
%     end
    
    waitbar(it/opt.iter, hdl);
end

close(hdl);
crit = crit(1:it);
time = cumsum(time(1:it));