function [u, it, time, crit] = DR2(u, f, h, opt)

% default inputs
if nargin < 2 || isempty(f),   f.fun = @(x) 0; f.prox = @(x,gamma) x;                                                end
if nargin < 3 || isempty(h),   h.fun = @(y) 0; h.prox = @(y,gamma) y; h.dir_op = @(x) x; h.adj_op = @(y) y; h.Q = 1; end
if nargin < 4 || isempty(opt), opt.tol = 1e-4; opt.iter = 500;                                                       end

% invert the matrix
[N,~,K] = size(h.Q);
Q = zeros(N,N,K);
for k = 1:K
    Q(:,:,k) = inv( eye(N) + h.Q(:,:,k) );
end

% select the step-sizes
gamma = 1;
mu    = 1.8;

% initialize the dual solution
x = u;
y = h.dir_op(u);

% execute the algorithm
time = zeros(1, opt.iter);
crit = zeros(1, opt.iter);
hdl = waitbar(0, 'Douglas-Rachford (block-diagonal)');
for it = 1:opt.iter
    
    tic;
    u_old = u;
    
    % average step
    z = x + h.adj_op(y);
    u = mtimesx(Q, z);
    v = h.dir_op(u);
    
    % primal step
    x = x + mu * f.prox(2*u - x, gamma) - mu * u;
    
    % dual step
    y = y + mu * h.prox(2*v - y, gamma) - mu * v; 

    % time and criterion
    time(it) = toc;
    crit(it) = f.fun(u) + h.fun(v);
           
    % stopping rule
    if norm( u(:) - u_old(:) ) < opt.tol * norm( u_old(:) ) && it > 10
        break;
    end
    
    waitbar(it/opt.iter, hdl);
end

close(hdl);
crit = crit(1:it);
time = cumsum(time(1:it));