function [x, it, time, crit] = FISTA(x, f, h, opt)

% default inputs
if nargin < 4 || isempty(opt), opt.tol = 1e-4;   opt.iter = 500;    end

% select the step-size
gamma = 1/h.lips;

% initialization
y = x;
t = 1;
d = 1;
a = 2.1;

% execute the algorithm
time = zeros(1, opt.iter);
crit = zeros(1, opt.iter);
hdl = waitbar(0, 'FISTA');
for it = 1:opt.iter
    
    tic;
       
    % gradient step
    v    = h.dir_op(x);
    grad = h.adj_op(h.grad(v));    
    
    % proximal step
    y_old = y;
    y = f.prox(x - gamma * grad, gamma);
    
    % line-search
    t_old = t;
    %t = beck_teboulle(t);
    t = aujol_dossal(it,a,d);
    
    % update step
    x_old = x;
    x = y + (t_old-1)/t * (y - y_old);
    
    % time and criterion
    time(it) = toc;
    crit(it) = f.fun(x) + h.fun(v);
           
    % stopping rule
    if norm( x(:) - x_old(:) ) < opt.tol * norm( x_old(:) ) && it > 10
        break;
    end
    
    waitbar(it/opt.iter, hdl);
end

close(hdl);
crit = crit(1:it);
time = cumsum(time(1:it));


function t = beck_teboulle(t)
    t = 0.5 * ( 1 + sqrt(1 + 4*t^2) );
    
function t = aujol_dossal(it,a,d)
    t = (it + a - 1) / a;
    t = t^d;