function [w, it, time, crit, conv] = ASYNC(w, f, h, opt, u_inf)

% default inputs
if nargin < 2 || isempty(f),   f.fun = @(x) 0; f.prox = @(x,gamma) x;                                                end
if nargin < 3 || isempty(h),   h.fun = @(y) 0; h.prox = @(y,gamma) y; h.dir_op = @(x) x; h.adj_op = @(y) y; h.Q = 1; end
if nargin < 4 || isempty(opt), opt.tol = 1e-4; opt.iter = 500;                                                       end

% select the step-sizes
tau   = 1;
gamma = 1; 
mu    = 1;
lambda = 1;

% initialize the variables
v = h.dir_op(w);
y = v;
s = v;
s_adj = h.adj_op(s);

% information for the random selection
args = [];

% execute the algorithm
time = zeros(1, opt.iter);
crit = zeros(1, opt.iter);
conv = zeros(1, opt.iter);
hdl = waitbar(0, 'Async. Johnstone-Eckstein');
for it = 1:(opt.iter*opt.coef)
    
    tic;
    w_old = w;
        
    % random selection
    [idx,args] = h.select(it,args);

    % primal step
    a = w - tau * h.adj_op(v);
    x = f.prox(a, tau);
    t = (a-x) / tau;
    
    % dual step
    r = h.dir_blk_op(w, idx) + gamma * v(idx,:,:);
    y(idx,:,:) = h.prox(r, gamma);
    s_old = s(idx,:,:);
    s_new = (r - y(idx,:,:)) / gamma;
    s(idx,:,:) = s_new;
    
    % step-size
    s_adj = s_adj + h.adj_blk_op(s_new - s_old, idx);
    z  = t + s_adj;
    u  = y - h.dir_op(x);
    pi = 1/lambda * sum(z(:).^2) + sum(u(:).^2);
    if pi>0
        xi = w(:)'*z(:) - x(:)'*t(:) + v(:)'*u(:) - y(:)'*s(:);
        alpha = mu/pi * max(0,xi);
    else
        alpha = 0;
    end
    
    % update step
    w = w - alpha/lambda*z;
    v = v - alpha*u;
    
    % time and criterion
    time(it) = toc;
    if rem(it-1,opt.coef) == 0
        crit(it-1+(1:opt.coef)) = f.fun(w) + h.fun(h.dir_op(w));
        conv(it-1+(1:opt.coef)) = norm(w(:)-u_inf(:)) / norm(u_inf(:));
    end
           
    % stopping rule
    if norm( w(:) - w_old(:) ) < opt.tol * norm( w_old(:) ) && it > 10
        %break;
    end
    
    waitbar(it/(opt.iter*opt.coef), hdl);
end

close(hdl);
crit = crit(1:it);
conv = conv(1:it);
time = cumsum(time(1:it));