function [u, it, time, crit, conv] = DR2_block(u, f, h, opt, u_inf)

% default inputs
if nargin < 2 || isempty(f),   f.fun = @(x) 0; f.prox = @(x,gamma) x;                                                end
if nargin < 3 || isempty(h),   h.fun = @(y) 0; h.prox = @(y,gamma) y; h.dir_op = @(x) x; h.adj_op = @(y) y; h.Q = 1; end
if nargin < 4 || isempty(opt), opt.tol = 1e-4; opt.iter = 500;                                                       end

% invert the matrix
[N,~,K] = size(h.Q);
Q = zeros(N,N,K);
for k = 1:K
    Q(:,:,k) = inv( eye(N) + h.Q(:,:,k) );
end

% select the step-sizes
gamma = 100;%500; % prima era 100
mu    = 1.8;%1.9; % prima era 1.8

% initialize the variables
x = u;
y = h.dir_op(u);
z = h.adj_op(y);

% information for the random selection
args = [];

% execute the algorithm
time = zeros(1, opt.iter);
crit = zeros(1, opt.iter);
conv = zeros(1, opt.iter);
hdl = waitbar(0, 'Block Coordinate Douglas-Rachford');
for it = 1:(opt.iter*opt.coef)
    
    tic;
    u_old = u;
        
    % random selection
    [idx,args] = h.select(it,args);

    % average step
    
    u     = Q*(x + z);
    %mtimesx(Q, x + z);
    v     = h.dir_blk_op(u, idx);

    % primal step
    x = x + mu * f.prox(2*u - x, gamma) - mu * u;

    % dual step
    y_old = y(idx,:,:);
    y_new = y_old + mu * h.prox(2*v - y_old, gamma) - mu * v;

    % update step
    y(idx,:,:) = y_new;
    z = z + h.adj_blk_op(y_new - y_old, idx);
    
    % time and criterion
    time(it) = toc;
    if rem(it-1,opt.coef) == 0
        crit(it-1+(1:opt.coef)) = f.fun(u) + h.fun(h.dir_op(u));
        conv(it-1+(1:opt.coef)) = norm(u(:)-u_inf(:)) / norm(u_inf(:));
    end
           
    % stopping rule
    if norm( u(:) - u_old(:) ) < opt.tol * norm( u_old(:) ) && it > 10
        break;
    end
    
    waitbar(it/(opt.iter*opt.coef), hdl);
end

close(hdl);
crit = crit(1:it);
conv = conv(1:it);
time = cumsum(time(1:it));