function [u, it, time, crit, conv] = DR_block(u, f, h, opt, u_inf)

% default inputs
if nargin < 2 || isempty(f),   f.fun = @(x) 0; f.prox = @(x,gamma) x;                                                end
if nargin < 3 || isempty(h),   h.fun = @(y) 0; h.prox = @(y,gamma) y; h.dir_op = @(x) x; h.adj_op = @(y) y; h.Q = 1; end
if nargin < 4 || isempty(opt), opt.tol = 1e-4; opt.iter = 500;                                                       end

% select the step-sizes
gamma = 0.5;
rho   = 0.1;%3.99;
mu    = 1.8;
tau   = 1;

% invert the matrix
Q = inv( eye(size(h.Q)) + tau*gamma / (1+gamma*rho) * h.Q );

% initialize the variables
x = u;
y = h.dir_op(u);
z = h.adj_op(y) / (1+gamma*rho);

%-------------
% OLD VERSION
%-------------
%z = h.adj_op(y);
%-------------

% information for the random selection
args = [];

% execute the algorithm
time = zeros(1, opt.iter);
crit = zeros(1, opt.iter);
conv = zeros(1, opt.iter);
hdl = waitbar(0, 'Block-Coordinate Primal-Dual Douglas-Rachford');
for it = 1:(opt.iter*opt.coef)
    
    tic;
        
    % random selection
    [idx,args] = h.select(it,args);

%---------------------------------------------------
% OLD VERSION - Initialized with z = h.adj_op(y);
%---------------------------------------------------
%     % average step
%     u_old = u;
%     u     = Q * (x - gamma/(1+gamma*rho) * z);
%     y_old = y(idx,:);
%     v     = (y_old + gamma * h.dir_blk_op(u, idx)) / (1+gamma*rho); 
% 
%     % primal step
%     x = x + mu * ( f.prox(2*u - x, gamma) - u );
% 
%     % dual step
%     s     = (2*v - y_old) / (1-gamma*rho);
%     y_new = y_old + mu * ( s - v - gamma/(1-gamma*rho) * h.prox(s/gamma*(1-gamma*rho), (1-gamma*rho)/gamma) );
%     
%     % update step
%     y(idx,:) = y_new;
%     z = z + h.adj_blk_op(y_new - y_old, idx);
%----------------------------------------------------

    % average step
    u_old = u;
    u     = Q * (x - tau * z);
    y_old = y(idx,:);
    v     = (y_old + gamma * h.dir_blk_op(u, idx)) / (1+gamma*rho); 

    % primal step
    x = x + mu * ( f.prox(2*u - x, tau) - u );

    % dual step
    p     = 2*v - y_old;
    y_new = y_old - mu * v + mu * (p - gamma * h.prox(p/gamma, (1-gamma*rho)/gamma))  / (1-gamma*rho);

    % update step
    y(idx,:) = y_new;
    z = z + h.adj_blk_op(y_new - y_old, idx) / (1+gamma*rho);
    
    % time and criterion
    time(it) = toc;
    if rem(it-1,opt.coef) == 0
        crit(it-1+(1:opt.coef)) = f.fun(u) + h.fun(h.dir_op(u));
        conv(it-1+(1:opt.coef)) = norm(u(:)-u_inf(:)) / norm(u_inf(:));
    end
           
    % stopping rule
    if norm( u(:) - u_old(:) ) < opt.tol * norm( u_old(:) ) && it > 10
        break;
    end
    
    waitbar(it/(opt.iter*opt.coef), hdl);
end

close(hdl);
crit = crit(1:it);
conv = conv(1:it);
time = cumsum(time(1:it));