function [x, it, time, crit, conv] = PD_block(x, f, g, h, opt, x_inf)

% default inputs
if nargin < 2 || isempty(f),   f.fun = @(x) 0; f.prox = @(x,gamma) x;                                                   end
if nargin < 3 || isempty(g),   g.fun = @(x) 0; g.grad = @(x)       0; g.beta   = 0;                                     end
if nargin < 4 || isempty(h),   h.fun = @(y) 0; h.prox = @(y,gamma) y; h.dir_op = @(x) x; h.adj_op = @(y) y; h.beta = 1; end
if nargin < 5 || isempty(opt), opt.tol = 1e-4; opt.iter = 500;                                                          end

% select the step-sizes
tau = 0.2 / (g.beta+2);
sigma = (1/tau - g.beta/2) / h.beta;

% initialize the variables
y = h.dir_op(x);
z = h.adj_op(y);

% information for the random selection
args = [];

% execute the algorithm
time = zeros(1, opt.iter);
crit = zeros(1, opt.iter);
conv = zeros(1, opt.iter);
hdl = waitbar(0, 'Block Coordinate Primal-Dual');
for it = 1:(opt.iter*opt.coef)
    
    tic;

    % random selection
	[idx,args] = h.select(it,args);
    
    % primal forward-backward step
    x_old = x;
    x = x - tau * (g.grad(x) + z);
    x = f.prox(x, tau);

    % dual forward-backward step    
    y_old = y(idx,:);
    y_new = y_old + sigma * h.dir_blk_op(2*x - x_old, idx);
    y_new = y_new - sigma * h.prox(y_new/sigma, 1/sigma);

    % update step
    y(idx,:) = y_new;
    z = z + h.adj_blk_op(y_new - y_old, idx);

    % time and criterion
    time(it) = toc;
    if rem(it-1,opt.coef) == 0
        crit(it-1+(1:opt.coef)) = f.fun(x) + g.fun(x) + h.fun(h.dir_op(x));
        conv(it-1+(1:opt.coef)) = norm(x(:)-x_inf(:)) / norm(x_inf(:));
    end
           
    % stopping rule
    if norm( x(:) - x_old(:) ) < opt.tol * norm( x_old(:) ) && it > 10
        break;
    end
    
%     if rem(it,10)
%         figure(10);
%         subplot(3,1,1); plot(x, 'linewidth', 2);
%         subplot(3,1,2); plot(y, 'linewidth', 2);
%         subplot(3,1,3); plot(z, 'linewidth', 2);
%     end
    
    waitbar(it/(opt.iter*opt.coef), hdl);
end

close(hdl);
crit = crit(1:it);
conv = conv(1:it);
time = cumsum(time(1:it));