function [w, it, time, crit, conv] = PFWD2(w, f, h, opt, u_inf)

% default inputs
if nargin < 4 || isempty(opt), opt.tol   = 1e-4;        opt.iter = 500; end
if ~isfield(opt,'gamma'),      opt.gamma = 1.99/h.lips;                 end

% parameters
tau   = 1;
gamma = 1/h.lips;
mu    = 1;
lambda = 1;

% initialize the variables
v = w;

% information for the random selection
args = [];

% execute the algorithm
time = zeros(1, opt.iter);
crit = zeros(1, opt.iter);
conv = zeros(1, opt.iter);
hdl = waitbar(0, 'Projective Forward Splitting (explicit)');
for it = 1:(opt.iter*opt.coef)
    
    tic;
    w_old = w;
    
    % random selection
    [idx,args] = h.select(it,args);
    
    % function f
    a = w - tau * v;
    x = f.prox(a, tau);
    t = (a-x) / tau;
    
    % function h
    grad = h.adj_blk_op(h.grad(h.dir_blk_op(w,idx)),idx);
    y = w - gamma * (grad - v);
    s = h.adj_blk_op(h.grad(h.dir_blk_op(y,idx)),idx);
    
    % step-size
    z  = t + s;
    u  = y - x;
    pi = 1/lambda * sum(z(:).^2) + sum(u(:).^2);
    if pi>0
        xi = w(:)'*z(:) - x(:)'*t(:) + v(:)'*u(:) - y(:)'*s(:);
        alpha = mu/pi * max(0,xi);
    else
        alpha = 0;
    end
    
    % update step
    w = w - alpha/lambda*z;
    v = v - alpha*u;
    
    % time and criterion
    time(it) = toc;
    if rem(it-1,opt.coef) == 0
        crit(it-1+(1:opt.coef)) = f.fun(w) + h.fun(h.dir_op(w));
        conv(it-1+(1:opt.coef)) = norm(w(:)-u_inf(:)) / norm(u_inf(:));
    end
           
    % stopping rule
    if norm( w(:) - w_old(:) ) < opt.tol * norm( w_old(:) ) && it > 10
        %break;
    end
    
    waitbar(it/(opt.iter*opt.coef), hdl);
end

close(hdl);
crit = crit(1:it);
conv = conv(1:it);
time = cumsum(time(1:it));