function [x, it, time, crit, conv] = RDA(x, f, h, opt, x_inf)

% default inputs
if nargin < 4 || isempty(opt), opt.tol   = 1e-4;        opt.iter = 500; end
if ~isfield(opt,'gamma'),      opt.gamma = 1.99/h.lips;                 end

% select the step-size
gamma = opt.gamma;

% information for the random selection
args = [];

% training size
L = size(h.dir_op(x),1);

% initialization
grad  = 0;

% execute the algorithm
time = zeros(1, opt.iter);
crit = zeros(1, opt.iter);
conv = zeros(1, opt.iter);
hdl = waitbar(0, 'Regularized Dual Averaging');
for it = 1:(opt.iter*opt.coef)
    
    tic;
    
    % random selection
    [idx,args] = h.select(it,args);
    B          = length(idx);
       
    % gradient step
    grad = grad + h.adj_blk_op(h.grad(h.dir_blk_op(x,idx)),idx);    
    
    % decreasing step-size 
    gt = gamma / sqrt(1+it);
    %gt = gamma;
    
    % proximal step
    x_old = x;
    x     = f.prox(-gt * grad, B/L * gt);
    
    % time and criterion
    time(it) = toc;
    if rem(it-1,opt.coef) == 0
        crit(it-1+(1:opt.coef)) = f.fun(x) + h.fun(h.dir_op(x));
        conv(it-1+(1:opt.coef)) = norm(x(:)-x_inf(:)) / norm(x_inf(:));
    end
           
    % stopping rule
    if norm( x(:) - x_old(:) ) < opt.tol * norm( x_old(:) ) && it > 10
        break;
    end
    
    waitbar(it/(opt.iter*opt.coef), hdl);
end

close(hdl);
crit = crit(1:it);
conv = conv(1:it);
time = cumsum(time(1:it));