function [idx,args] = random_selection(it, args, batch, minibatch, mode)

if nargin < 5, mode = 'cyclic'; end

if strcmpi(mode, 'cyclic')
    
    i = rem( (it-1)*minibatch, batch );
    idx = i+1 : min(i+minibatch, batch);
    
elseif strcmpi(mode, 'pooling')
    
    i = rem( (it-1)*minibatch, batch );
    if i == 0
        args = randperm(batch);
    end
    idx = args( i+1 : min(i+minibatch,batch) );
    
else
    idx = randperm(batch, minibatch);
end
