function f = set_loss_binary(loss, samples, labels, minibatch, normalize, skip)

% operator norm
if ~skip
    f.dir_op = @(w) -labels(:,1) .* (samples       * w);
    f.adj_op = @(v) samples'      * (-labels(:,1) .* v);
    opnorm   = compute_linop_norm([size(samples,2),1], f);
end

% normalization
M = 1;
if normalize
    M = opnorm;
    samples = samples / M;
    opnorm = 1;
end

% linear operator
f.dir_op = @(w) -labels .* (samples  * w);
f.adj_op = @(v) samples' * (-labels .* v);

% block linear operator
f.dir_blk_op = @(w,idx) -labels(idx,:) .* (samples(idx,:)  * w);
f.adj_blk_op = @(v,idx) samples(idx,:)' * (-labels(idx,:) .* v);

% minibatch selector
L = size(samples,1);
f.select = @(it,args) random_selection(it, args, L, minibatch, 'pooling');

% proximity operator
if strcmpi(loss, 'logit')
    f.fun  = @(v)         fun_logit(M*v, 1);
    f.grad = @(v)        grad_logit(M*v, M);
    f.prox = @(v, gamma) prox_logit(M*v, gamma*M^2)/M;
elseif strcmpi(loss, 'hinge')
    f.fun  = @(v)         fun_hinge(1 + M*v, 1);
    f.grad = @(v)        grad_hinge(1 + M*v, M);
    f.prox = @(v, gamma) prox_hinge(1 + M*v, gamma*M^2)/M - 1/M;
else
    error('Loss not supported');
end

% symmetrix matrix (required by primal algorithms)
if ~skip
    f.Q = samples' * samples;
end

% operator norm (required by primal-dual algorithms)
if ~skip 
    f.beta = opnorm^2;
end

% lipschitz constant (required by gradient algorithms)
if ~skip
    f.lips = opnorm^2 / 4;
end