function f = set_prior(prior, lambda)

if strcmpi(prior, 'l2')

    f.fun  = @(w)         fun_square(w, lambda);
    f.grad = @(w)        grad_square(w, lambda);
    f.prox = @(w, gamma) prox_square(w, lambda * gamma);
    
elseif strcmpi(prior, 'l1')

    f.fun  = @(w)         fun_abs(w, lambda);
    f.grad = @(w)        grad_abs(w, lambda);
    f.prox = @(w, gamma) prox_abs(w, lambda * gamma);
    
else
    error('Prior not supported');
end