function [x, it, time, crit] = train_classifier_multiclass(dataset, loss, minibatch, prior, lambda, algo, opt)

% problem size
L = size(dataset.samples,1);       % num. of samples
N = size(dataset.samples,2);       % num. of features
K = max( unique(dataset.labels) ); % num. of classes (K=1 -> binary)
if K == 1
    error('Dataset only contains two labels.');
end

% normalization
flag = '';
if any(strcmpi(algo, {'pd', 'bcpd'}))
    flag = 'normalize';
end

% proximity operators
f = set_prior(prior, lambda);
h = set_loss_multiclass(loss, dataset.samples, dataset.labels, minibatch, flag);

% initialization
x = randn(N,K);

% optimization
[x,it,time,crit] = exec_algo(algo, x, f, h, opt);