 function p = fun_hinge(x, gamma)
%function p = fun_hinge(x, gamma)
%
% This procedure evaluates the function:
%
%                    f(x) = gamma * max{x,0}
%
% When the input 'x' is an array, the output 'p' is the element-wise sum.
%
%  INPUTS
% ========
%  x     - ND array
%  gamma - positive, scalar or ND array with the same size as 'x'


% check input
if any( gamma(:) <= 0 ) || ~isscalar(gamma) && any(size(gamma) ~= size(x))
    error('''gamma'' must be positive and either scalar or the same size as ''x''')
end
%-----%


% evaluate the function
p = sum( gamma(:) .* max(x(:),0) );