 function p = grad_hinge(x, gamma)
%function p = grad_hinge(x, gamma)
%
% This procedure evaluates the gradient of:
%
%                    f(x) = gamma * max{x,0}^2
%
% When the input 'x' is an array, the output 'p' is the element-wise sum.
%
%  INPUTS
% ========
%  x     - ND array
%  gamma - positive, scalar or ND array with the same size as 'x'


% check input
if any( gamma(:) <= 0 ) || ~isscalar(gamma) && any(size(gamma) ~= size(x))
    error('''gamma'' must be positive and either scalar or the same size as ''x''')
end
%-----%


% evaluate the function
p = 2*gamma .* max(x,0);