 function p = grad_square(x, gamma)
%function p = grad_square(x, gamma)
%
% This procedure evaluates the gradient of:
%
%                       f(x) = gamma/2 * x^2
%
% When the input 'x' is an array, the output 'p' is the element-wise sum.
%
%  INPUTS
% ========
%  x     - ND array
%  gamma - positive, scalar or ND array with the same size as 'x'


% check input
if any( gamma(:) <= 0 ) || ~isscalar(gamma) && any(size(gamma) ~= size(x))
    error('''gamma'' must be positive and either scalar or the same size as ''x''')
end
%-----%


% evaluate the gradient
p = gamma .* x(:);