 function p = prox_hinge(x, gamma)
%function p = prox_hinge(x, gamma)
%
% This procedure computes the proximity operator of the function:
%
%                    f(x) = gamma * max{x,0}
%
% When the input 'x' is an array, the output 'p' is computed element-wise.
%
%  INPUTS
% ========
%  x     - ND array
%  gamma - positive, scalar or ND array with the same size as 'x'


% check input
if any( gamma(:) <= 0 ) || ~isscalar(gamma) && any(size(gamma) ~= size(x))
    error('''gamma'' must be positive and either scalar or the same size as ''x''')
end
%-----%


% compute the prox
p = min(0, x) + max(0, x-gamma);