function [Y,varargout] = normalization(X, mode)
% This function normalizes each column of an array.
%
%  INPUT
% =======
%    X - array of data point where each row corresponds to an observation and each column corresponds to a variable
% mode - what type of normalization ['standard', 'scaling', 'unitary']

if nargin < 2
    mode = 'standard';
end

if strcmpi(mode, 'standard')
    
    Mean = mean(X);
    Std  = std(X);
    
    Y = bsxfun( @minus,   X, Mean );
    Y = bsxfun( @rdivide, Y, Std  );
    
    varargout{1} = Mean;
    varargout{2} = Std;
        
elseif strcmpi(mode, 'scaling')
    
    Max = max(X);
    Min = min(X);
    
    Y = bsxfun(@minus,   X, Min);
    Y = bsxfun(@rdivide, Y, Max-Min);
    
    varargout{1} = Min;
    varargout{2} = Max;
        
elseif strcmpi(mode, 'unitary')
    
    Norm = sqrt(sum(X.^2,2));
    
    Y = bsxfun(@rdivide, X, Norm);
    
    varargout{1} = Norm;
    
else
    error('Unknown normalization');
end