function idx = stratified_holdout(labels, test_ratio)

if nargin < 2
    test_ratio = 0.3;
end

% check for labels in {-1,+1}
if min(labels) == -1
    labels = (1+labels) / 2;
    labels = labels + 1;
end

N = length(labels);
size_groups = accumarray(labels(:),1);
num_test = floor(size_groups * test_ratio);

test_diff = floor(N * test_ratio) - sum(num_test);
%add 1 for groups which are not in the test set
if any(num_test == 0)
    v=(num_test == 0);
    v(cumsum(v) > test_diff) = false;
    num_test(v) = num_test(v) + 1;
    test_diff = test_diff - sum(v);
end

if test_diff > 0
    ng= numel(size_groups);
    wasfull  =(num_test == size_groups);
    full_len = sum(wasfull);
    add = [ones(test_diff,1);zeros(ng - test_diff - full_len,1)];
    [~,indices] =  sort(rand(1,(ng-full_len))); % randperm
    add = add(indices);
    x = zeros(size(wasfull));
    x(~wasfull,:) = add;
    num_test = num_test + x;

end

if any(num_test == 0)
    warning('holdout:empty:validation', 'Validation set is empty');
end

if any(num_test == size_groups)
    warning('holdout:empty:training', 'Training set is empty');
end

idx = 2*ones(N,1);
for i = 1:numel(size_groups)
    g_idx = find(labels == i);
    idx(g_idx(1:size_groups(i)-num_test(i))) = 1;
    [~,indices] = sort(rand(1,(size_groups(i)))); % randperm
    idx(g_idx) = idx(g_idx( indices ));
end