function cvid = stratified_kfold(labels, nfold)

% check for labels in {-1,+1}
if min(labels) == -1
    labels = (1+labels) / 2;
    labels = labels + 1;
end

size_groups = accumarray(labels(:),1);
if any(size_groups < nfold & size_groups > 0)
    warning('Missing group');
end

N = size(labels,1);
cvid = 1 + mod((1:N)',nfold);
idrand = labels + rand(N,1);
[~,idx] = sort(idrand);
cvid(idx) = cvid;