function z = tensor_prod(x, T, dim)
%
% The function transforms 'x' along the dimension 'dim' using the rows of 'T'.
%

if dim == 1
    
    z = mtimesx(T, x);

elseif dim == 2

    z = mtimesx(x, T, 't');

else
    
    sz = size(x);
    x = reshape(x, [prod(sz(1:dim-1)) sz(dim) sz(dim+1:end)]);
    z = mtimesx(x, T, 't');
    z = reshape(z, [sz(1:dim-1) size(T,1) sz(dim+1:end)]);
    
end