options = glmnetSet; 
options.nlambda = 3; 
%options.lambda = [3;2;1] / (2*size(trainset.samples,1));
options.standardize=0; 
options.intr=0; 

if length(unique(trainset.labels)) > 2
    tic; fit = glmnet(trainset.samples, trainset.labels-1, 'multinomial', options); toc
else
    tic; fit = glmnet(trainset.samples, trainset.labels, 'binomial', options); toc
end
%w = fit.beta(:,2);

% define the predictor
if length(unique(trainset.labels)) > 2
    predict = @(u,samples)   sign(samples * u);
else
    predict = @(u,samples) argmax(samples * u, 2);
end

% test the classifier
y_train = predict(w, trainset.samples);
y_test  = predict(w,  testset.samples);   

train_errors = sum(repmat(trainset.labels, [1 3]) ~= y_train, 1);
 test_errors = sum(repmat( testset.labels, [1 3]) ~= y_test , 1);
 
train_err = 100 * train_errors / size(trainset.samples,1);
 test_err = 100 *  test_errors / size(testset.samples,1);
 
sparsity = 100 * sum(abs(fit.beta)<1e-2,1) / size(fit.beta,1);
 
%fprintf('%6s (%s, loss: %s, prior: %s, lambda: %1.1e) - Training errors: %2.2f %% - Test errors: %2.2f %% - Time: %4.2f s - Iter.: %4d - Crit.: %.2f - Sparsity: %.2f %%\n', algo, classifier, loss, prior, lambda, 100 * train_errors / size(trainset.samples,1), 100 * test_errors / size(testset.samples,1), time(end), it, crit(end), 100 * sum(abs(w(:))<1e-2) / numel(w) );

